/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationProperties {
    private static final Logger log = LoggerFactory.getLogger(ApplicationProperties.class);
    public static final String USER = "user";
    public static final String SERVER_HOST = "server_host";
    public static final String SERVER_REGISTRY_PORT = "server_registry_port";
    public static final String SERVER_URL = "server_url";
    public static final String SESSION_MANAGER_BIND_NAME = "session_manager_bind_name";
    public static final String START_PERSPECTIVE = "inplan.start.perspective";
    public static final String DEFAULT_COMPLETED_FILTER = "inplan.default_completed_filter";
    public static final String DEFAULT_REPLAN_DELAYED = "default_replan_delayed";
    public static final String PROPERTY_EDITOR_HIGH_PRECISION = "property_editor.high_precision";
    private static final Pattern knownProps = Pattern.compile("(^\\Quser\\E$)|(^\\Qserver_host\\E$)|(^\\Qserver_registry_port\\E$)|(^\\Qserver_url\\E$)|(^\\Qsession_manager_bind_name\\E$)|(^\\Qinplan.default_completed_filter\\E$)|(^\\Qdefault_replan_delayed\\E$)|(^\\Qinplan.start.perspective\\E$)|(^\\Qproperty_editor.high_precision\\E$)|(^param\\..*$)");
    private static final Properties props = new Properties();

    public static Set<Map.Entry<Object, Object>> entrySet() {
        return props.entrySet();
    }

    public static final String getProperty(String name) {
        return props.getProperty(name);
    }

    public static final String getProperty(String name, String defaultValue) {
        return props.getProperty(name, defaultValue);
    }

    public static final String getRequiredProperty(String name) throws IllegalStateException {
        String val = ApplicationProperties.getProperty(name);
        if (val == null) {
            throw new IllegalStateException("Property " + name + " is not set.");
        }
        return val;
    }

    public static void setProperty(String name, String value) {
        props.setProperty(name, value);
    }

    private ApplicationProperties() {
    }

    static {
        Properties sysProps = System.getProperties();
        InputStream propStream = ApplicationProperties.class.getResourceAsStream("in_plan_client.properties");
        try {
            props.load(propStream);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        for (Object propKey : sysProps.keySet()) {
            String propName = (String)propKey;
            Matcher matcher = knownProps.matcher(propName);
            if (!matcher.find()) continue;
            props.put(propName, sysProps.get(propName));
        }
    }
}

